% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrbound2Binary.R
\name{corrbound2Binary}
\alias{corrbound2Binary}
\title{Calculate Correlation Bounds Between Two Binary Outcomes}
\usage{
corrbound2Binary(p1, p2)
}
\arguments{
\item{p1}{True probability of responders for the first outcome (0 < p1 < 1)}

\item{p2}{True probability of responders for the second outcome (0 < p2 < 1)}
}
\value{
A named numeric vector with two elements:
\item{L_bound}{Lower bound of the correlation}
\item{U_bound}{Upper bound of the correlation}
}
\description{
Computes the lower and upper bounds of the correlation coefficient between
two binary outcomes based on their marginal probabilities, as described in
Prentice (1988).
}
\details{
For two binary outcomes with marginal probabilities p1 and p2, the correlation
coefficient rho is bounded by:
\deqn{\rho \in [L(p_1, p_2), U(p_1, p_2)]}
where
\deqn{L(p_1, p_2) = \max\left\{-\sqrt{\frac{p_1 p_2}{(1-p_1)(1-p_2)}},
      -\sqrt{\frac{(1-p_1)(1-p_2)}{p_1 p_2}}\right\}}
\deqn{U(p_1, p_2) = \min\left\{\sqrt{\frac{p_1(1-p_2)}{p_2(1-p_1)}},
      \sqrt{\frac{p_2(1-p_1)}{p_1(1-p_2)}}\right\}}
}
\examples{
# Calculate correlation bounds for two binary outcomes
corrbound2Binary(p1 = 0.3, p2 = 0.5)

# When probabilities are equal, upper bound is 1
corrbound2Binary(p1 = 0.4, p2 = 0.4)

# When p1 + p2 = 1, lower bound is -1
corrbound2Binary(p1 = 0.3, p2 = 0.7)

}
\references{
Prentice, R. L. (1988). Correlated binary regression with covariates specific
to each binary observation. \emph{Biometrics}, 44(4), 1033-1048.
}
