% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr1Binary.R
\name{rr1Binary}
\alias{rr1Binary}
\title{Rejection Region for Two-Arm Trials with a Single Binary Endpoint}
\usage{
rr1Binary(n1, n2, alpha, Test)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{alpha}{One-sided significance level (typically 0.025)}

\item{Test}{Type of statistical test. One of:
\itemize{
\item \code{"Chisq"}: One-sided Pearson chi-squared test
\item \code{"Fisher"}: Fisher exact test
\item \code{"Fisher-midP"}: Fisher mid-p test
\item \code{"Z-pool"}: Z-pooled exact unconditional test
\item \code{"Boschloo"}: Boschloo exact unconditional test
}}
}
\value{
A logical matrix of dimensions (n1+1) x (n2+1), where TRUE indicates
rejection of the null hypothesis. Rows correspond to the number of responders
in group 1 (0 to n1), and columns correspond to the number of responders in
group 2 (0 to n2).
}
\description{
Calculates the rejection region for two-arm trials with a single binary endpoint
using various exact statistical tests, as described in Homma and Yoshida (2025).
}
\details{
This function computes the rejection region for five different one-sided tests:

\strong{Chi-squared test:} Uses the asymptotic normal approximation of the
chi-squared statistic.

\strong{Fisher exact test:} Uses the hypergeometric distribution to calculate
exact p-values conditional on the total number of successes.

\strong{Fisher mid-p test:} Modification of Fisher's exact test that adds half
the probability of the observed outcome to reduce conservatism.

\strong{Z-pooled test:} Exact unconditional test that maximizes p-values over
all possible values of the nuisance parameter (common success probability under H0).

\strong{Boschloo test:} Exact unconditional test similar to Z-pooled but based
on Fisher's exact p-values, maximizing over the nuisance parameter.
}
\examples{
# Simple example with small sample sizes
n1 <- 5
n2 <- 5
alpha <- 0.025
RR <- rr1Binary(n1, n2, alpha, Test = 'Chisq')
print(dim(RR))  # Should be (6, 6)

# Fisher exact test
RR_fisher <- rr1Binary(n1 = 10, n2 = 10, alpha = 0.025, Test = 'Fisher')

\donttest{
# More computationally intensive: Boschloo test
n1 <- 20
n2 <- 10
alpha <- 0.025
RR <- rr1Binary(n1, n2, alpha, Test = 'Boschloo')
print(RR)
}

}
\references{
Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
