% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss2BinaryApprox.R
\name{ss2BinaryApprox}
\alias{ss2BinaryApprox}
\title{Sample Size Calculation for Two Co-Primary Binary Endpoints (Asymptotic Approximation)}
\usage{
ss2BinaryApprox(p11, p12, p21, p22, rho1, rho2, r, alpha, beta, Test)
}
\arguments{
\item{p11}{True probability of responders in group 1 for the first outcome (0 < p11 < 1)}

\item{p12}{True probability of responders in group 1 for the second outcome (0 < p12 < 1)}

\item{p21}{True probability of responders in group 2 for the first outcome (0 < p21 < 1)}

\item{p22}{True probability of responders in group 2 for the second outcome (0 < p22 < 1)}

\item{rho1}{Correlation between the two outcomes for group 1}

\item{rho2}{Correlation between the two outcomes for group 2}

\item{r}{Allocation ratio of group 1 to group 2 (group 1:group 2 = r:1, where r > 0)}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{beta}{Target type II error rate (typically 0.1 or 0.2)}

\item{Test}{Statistical testing method. One of:
\itemize{
\item \code{"AN"}: Asymptotic normal method without continuity correction
\item \code{"ANc"}: Asymptotic normal method with continuity correction
\item \code{"AS"}: Arcsine method without continuity correction
\item \code{"ASc"}: Arcsine method with continuity correction
}}
}
\value{
A data frame with the following columns:
\item{p11, p12, p21, p22}{Response probabilities}
\item{rho1, rho2}{Correlations}
\item{r}{Allocation ratio}
\item{alpha}{One-sided significance level}
\item{beta}{Type II error rate}
\item{Test}{Testing method used}
\item{n1}{Required sample size for group 1}
\item{n2}{Required sample size for group 2}
\item{N}{Total sample size (n1 + n2)}
}
\description{
Calculates the required sample size for a two-arm superiority trial with two
co-primary binary endpoints using asymptotic normal approximation or arcsine
transformation, as described in Sozu et al. (2010).
}
\details{
This function uses a sequential search algorithm (Homma and Yoshida 2025,
Algorithm 1) to find the minimum sample size:

\strong{Step 1:} Initialize with sample sizes from single endpoint formulas.

\strong{Step 2:} Use sequential search:
\itemize{
\item Calculate power at initial sample size
\item If power >= target: decrease n2 until power < target, then add 1 back
\item If power < target: increase n2 until power >= target
}

\strong{Step 3:} Return final sample sizes.

The asymptotic normal (AN) and arcsine (AS) methods use normal approximation
with or without continuity correction. For small sample sizes or extreme
probabilities, consider using exact methods via \code{\link{ss2BinaryExact}}.
}
\examples{
# Sample size calculation using asymptotic normal method
ss2BinaryApprox(
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.5,
  rho2 = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.2,
  Test = 'AN'
)

# With continuity correction
ss2BinaryApprox(
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.5,
  rho2 = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.2,
  Test = 'ANc'
)

# Using arcsine transformation
ss2BinaryApprox(
  p11 = 0.5,
  p12 = 0.4,
  p21 = 0.3,
  p22 = 0.2,
  rho1 = 0.5,
  rho2 = 0.5,
  r = 1,
  alpha = 0.025,
  beta = 0.2,
  Test = 'AS'
)

}
\references{
Sozu, T., Sugimoto, T., & Hamasaki, T. (2010). Sample size determination in
clinical trials with multiple co-primary binary endpoints. \emph{Statistics
in Medicine}, 29(21), 2169-2179.

Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
