% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medrank.R
\name{medrank}
\alias{medrank}
\title{Median rank method to estimate parameters of the two-parameter exponential dist.}
\source{
Reid, M. (2022). Reliability – a Python library for reliability engineering (Version 0.8.2) [Computer software].
Zenodo. \doi{https://doi.org/10.5281/ZENODO.3938000}.
}
\usage{
medrank(x, methods = c("B"))
}
\arguments{
\item{x}{vector of quantile (or a data set).}

\item{methods}{there are some of median rank methods as follows;
"B"  stand for Benard median rank method (default),
"BL" stand for Blom method,
"MKM" stand for Hazen (Modified Kaplan Meier) method,
"OT" stand for The one-third method, and
"C"  stand for Cunane method}
}
\value{
the estimate three values for the two-parameter exponential dist. as follows:
\code{theta.hat}  gives the estimate location parameter,
\code{beta.hat}   gives the estimate scale parameter,
and \code{lamda.hat} gives the estimate the rate.
}
\description{
Median rank method to estimate parameters of the two-parameter exponential dist.
}
\examples{
x1 <- c(25,43,53,65,76,86,95,115,132,150) # test a data set
medrank(x1,"B")    # Benard method (default) or medrank(x1)

}
