% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.twoway.R
\name{plot.twoway}
\alias{plot.twoway}
\alias{plot.twoway.fit}
\alias{plot.twoway.diagnose}
\title{Plot methods for two-way tables}
\usage{
\method{plot}{twoway}(x, which = c("fit", "diagnose"), ...,
  na.rm=any(is.na(x$residuals)))

\method{plot}{twoway.fit}(x, main = paste0("Tukey two-way fit plot for ",
  x$name, " (method: ", x$method, ")"), xlab = expression(hat(mu) *
  " + Column Effect - Row Effect"), ylab = expression("Fit = " * hat(mu)
  * " + Column Effect + Row Effect"), rfactor = 1, rcolor = c("blue",
  "red"), lwd = 3, ylim = NULL, ...,
  na.rm=any(is.na(x$residuals)))

\method{plot}{twoway.diagnose}(x, annotate = TRUE, jitter = FALSE,
  smooth = FALSE, pch = 16, ...)
}
\arguments{
\item{x}{a \code{class("twoway")} object}

\item{which}{one of \code{"fit"} or \code{"diagnose"}}

\item{...}{other arguments, passed to \code{plot}}

\item{na.rm}{logical. Should missing values be removed?}

\item{main}{plot title}

\item{xlab}{X axis label}

\item{ylab}{Y axis label}

\item{rfactor}{draw lines for \code{abs(residuals) > rfactor*sqrt(MSPE)}}

\item{rcolor}{a vector of length 2 giving the color of lines for positive and negative residuals}

\item{lwd}{line width for residual lines in the fit plot}

\item{ylim}{Y axis limits}

\item{annotate}{A logical value; if \code{TRUE}, the slope and power are displayed in the diagnostic plot}

\item{jitter}{A logical value; if \code{TRUE}, the comparison values in the plot are jittered to avoid overplotting}

\item{smooth}{A logical value; if \code{TRUE}, a smoothed \code{\link[stats]{loess}} curve is added to the plot}

\item{pch}{Plot character for point symbols in the diagnostic plot}
}
\value{
The diagnostic plot invisibly returns a list with elements \code{c("slope", "power")}
}
\description{
Plots either the fitted values and residuals under additivity or
a diagnostic plot for removable non-additivity by a power transformation
}
\details{
For the \code{which="fit"} plot, the basic result comes from a plot of the row effects against the column fitted
    values, which appears as a rectangular grid in these coordinates.  Rotating this 45 degrees counterclockwise give a plot
    in which the vertical coordinate is the fitted value for the two-way table, and the horizontal coordinate is the column fit
    minus the row effect.  The spacing of the grid lines for the rows and columns of the table show the relative magnitudes of the
    row/column means or medians.

    For the \code{which="diagnose"} plot, the interaction residuals from an additive model, \eqn{y_{ij} = \mu + \alpha_i + \beta_j},
    are plotted against the estimated components \eqn{\alpha_i \beta_j / \mu}. If this plot shows a substantially non-zero
    slope, \eqn{b}, this analysis suggests that a power transformation, \eqn{ y \rightarrow y^(1-b)} might reduce the
    apparent interaction effects.

For both plots, if you want to directly compare the result of \code{method="mean"} and \code{method="median"}, it is
     essential to set the same \code{xlim} and \code{ylim} axes in the call.
}
\examples{
data(taskRT)
tw <- twoway(taskRT)
tw
twmed <- twoway(taskRT, method="median")
twmed
plot(tw,    xlim=c(2,7), ylim=c(2,7)) ## use the same xlim and ylim, for comparison
plot(twmed, xlim=c(2,7), ylim=c(2,7))

plot(tw,    which="diagnose", xlim=c(-.19, .19), ylim=c(-.5, .55))
plot(twmed, which="diagnose", xlim=c(-.19, .19), ylim=c(-.5, .55))

data(insectCounts)
twi <- twoway(insectCounts)
twimed <- twoway(insectCounts, method="median")

plot(twi,    xlim=c(-250, 700), ylim=c(-180, 900))
plot(twimed, xlim=c(-250, 700), ylim=c(-180, 900))

plot(twi,    which="diagnose", xlim=c(-160, 170), ylim=c(-200, 400))  ## power = .1
plot(twimed, which="diagnose", xlim=c(-160, 170), ylim=c(-200, 400))  ## power = .3

}
