% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_question_mark.R, R/02_declare.R
\name{?}
\alias{?}
\alias{declare}
\title{Set Variable Types, Argument Types and Return Types.}
\usage{
`?`(lhs, rhs)

declare(x, assertion, value, const = FALSE)
}
\arguments{
\item{lhs}{lhs}

\item{rhs}{rhs}

\item{x}{variable name as a string}

\item{assertion}{a function}

\item{value}{an optional value}

\item{const}{whether to declare \code{x} as a constant}
}
\value{
\code{declare} (and \verb{?} when it maps to \code{declare}) returns \code{value} invisibly, it is called for side effects.
\verb{assertion ? function(<args>) \{<body>\}} returns a typed function, of class \code{c("typed", "function")}.
\verb{fun <- assertion ? function(<args>) \{<body>\}} returns a typed function and
binds it to \code{fun} in the local environment.
}
\description{
Use \verb{?} to set a function's return type, argument types, or variable types
in the body of the function. \code{declare} is an alternative to set a variable's
type.
}
\section{Set A Variable's Type}{


When used to set a variable's type, \verb{?} maps
to \code{declare} so that \code{assertion ? var} calls \code{declare("var", assertion)},
\code{assertion ? var <- value} calls \code{declare("var", assertion, value)}, and
\code{assertion ? (var) <- value} calls \code{declare("var", assertion, value, const = TRUE)}

In those cases an active binding is defined so \code{var} returns \code{value} (or
\code{NULL} if none was provided). If \code{const} is \code{FALSE} (the default), the
returned value can then be altered if by assigning to \code{var}, but a value which
doesn't satisfy the assertion will trigger an error.
}

\section{Set A Function's Return Type}{


The syntaxes \verb{assertion ? function(<args>) \{<body>\}} and \verb{fun <- assertion ? function(<args>) \{<body>\}}
can be used to create a function of class \code{c("typed", "function")}.
The returned function will have its body modified so that return values are
wrapped inside a \code{check_output()} call. Printing the function will display
the return type.
}

\section{Set A Function Argument's Type}{


When using the above syntax, or if we don't want to force a return type, the
simpler \verb{? function(<args>) \{<body>\}} or \verb{fun <- ? function(<args>) \{<body>\}}
syntax, we can set argument types by providing arguments as \code{arg = default_value ? assertion} or
\code{arg = ? assertion}. When entering the function, argument types will be checked.

By default the arguments are only checked at the top, and might be assigned later
in the function's body values that don't satisfy the assertion, to avoid this
we can type \code{arg = default_value ? +assertion} or \code{arg = ? +assertion}.

Note that forgetting the \verb{?} before \code{function} is an easy mistake to do!

If we'd rather check the quoted argument rather than the argument's value,
we can type \code{arg = default_value ? ~assertion} or
\code{arg = ? ~assertion}. A possible use case might be \code{arg = ? ~ Symbol()}.

Dots can be checked too, \code{... = ? assertion} will make sure that every argument
passed to dots satisfies the assertion.

The special assertion factory \code{Dots} can also be used, in that case the checks will
apply to \code{list(...)} rather than to each element individually, for instance
\verb{function(... = ? Dots(2))} makes sure the dots were fed 2 values.

The returned function will have its body modified so the arguments are
checked by \code{check_arg()} calls at the top. Printing the function will display
the argument types.
}

\examples{
Integer() ? function (x= ? Integer()) {
  Integer() ? y <- 2L
  res <- x + y
  res
}
}
