% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewbabynames.R
\docType{data}
\name{ewbabynames}
\alias{ewbabynames}
\title{England & Wales baby names}
\format{
A data frame with 294,801 observations on 6 variables.
\describe{
\item{year}{A year (1996-2020).}
\item{sex}{Sex, \code{M} for male and \code{F} for female.}
\item{name}{A name.}
\item{n}{Count of name within year and sex.}
\item{rank}{Rank of name within year and sex.}
\item{nation}{Nation of data source: \code{England & Wales}.}
}
}
\source{
Office of National Statistics. 2021. \href{https://www.ons.gov.uk/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/datasets/babynamesenglandandwalesbabynamesstatisticsgirls}{Baby Names Statistics Girls}.
Office of National Statistics. 2021. \href{https://www.ons.gov.uk/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/datasets/babynamesenglandandwalesbabynamesstatisticsboys}{Baby Names Statistics Boys}.
}
\usage{
ewbabynames
}
\description{
Full baby name data from 1996 to 2020 for England and Wales
from the Office of National Statistics.
}
\details{
The data are released by the Office of National Statistics under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government License v3.0}.
}
\examples{
library(ggplot2)
library(dplyr)

ewbabynames \%>\%
  filter(name == "Nicholas") \%>\%
  ggplot(aes(x = year, y = n)) +
  geom_line() +
  labs(
    title = "Popularity of the name `Nicholas` in England & Wales", 
    x = "Year", 
    y = "Number of babies"
    )
}
\seealso{
\link{rankings}
}
\keyword{datasets}
