% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_qc_flags_user.R
\name{compute_extended_ratio_qc_flags}
\alias{compute_extended_ratio_qc_flags}
\title{Aggregate QC Flags when computing the extended set of biomarker ratios}
\usage{
compute_extended_ratio_qc_flags(x)
}
\arguments{
\item{x}{\code{data.frame} containing NMR metabolomics data from UK Biobank.
May either be raw field data output by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
or data with column names corresponding to biomarkers listed in \code{\link{nmr_info}}.}
}
\value{
a \code{data.frame} with QC flags aggregated for all computed
        biomarker ratios.
}
\description{
For the 76 biomarker ratios computed by \code{\link{compute_extended_ratios}()},
aggregates the biomarker QC flags from the biomarkers composing each ratio
(see \code{\link{nmr_info}}), which can be useful for determining the reason
underlying missing values in the biomarker ratios.
}
\details{
If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.

Biomarker QC Flags in the input data are also returned alongside those
aggregated by this function for the computed biomarker ratios.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
biomarker_qc_flags <- compute_extended_ratio_qc_flags(ukb_data)

}
\seealso{
\code{\link{nmr_info}} for list of computed biomarker ratios and
  \code{\link{extract_biomarkers}()} for details on how raw data from
  \href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
  is processed.
}
