% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dbe.R
\name{calc_dbe}
\alias{calc_dbe}
\title{Calculate Double Bond Equivalent (DBE)}
\usage{
calc_dbe(mfd, masses = ume::masses, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{masses}{A data.table. Defaults to \code{ume::masses} (based on NIST data)
containing isotope information for elements, including nominal and exact mass,
relative abundance, and Hill system order.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A numeric vector of the same length as the number of rows in \code{mfd},
where each entry represents the calculated DBE for the corresponding molecular formula.
The result vector is named 'dbe'.
}
\description{
Calculates the Double Bond Equivalent (DBE) for a given neutral molecular formula.
DBE is a measure of unsaturation, representing the total number of rings and pi bonds
in a molecule. This function uses the \code{masses} data table to determine valence information
for each element in the input molecular formula.
}
\details{
This function computes DBE based on the molecular formula specified in \code{mfd}.
\code{mfd} can be a data.table or a character string or character vector of molecular formula strings.

For each isotope in the formula, DBE is calculated as the sum of (valence - 2)
multiplied by the count of that isotope, divided by 2, and then adding 1.
Elements with a valence of 2 are excluded from the DBE calculation.

The function will stop and print an error if any elements in \code{mfd} have missing valence information
in \code{masses}.
}
\examples{
# Example with user-defined data
calc_dbe("C6H10O6")
calc_dbe("C6H10Br2")
calc_dbe(c("C3[13C1]H10O4", "C6H10O6"))

# Example with demo data from UME package
calc_dbe(mfd = mf_data_demo)

}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
