% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_data_table_to_molecular_formulas.R
\name{convert_data_table_to_molecular_formulas}
\alias{convert_data_table_to_molecular_formulas}
\title{Convert Data Table with Element Counts to Molecular Formulas}
\usage{
convert_data_table_to_molecular_formulas(
  mfd,
  isotope_formulas = FALSE,
  keep_element_sums = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{isotope_formulas}{Logical. If \code{TRUE} the output table will have an additional
molecular formula string that includes isotope information (e.g. "[12C5][13C1][1H12][16O6]")}

\item{keep_element_sums}{description. If \code{TRUE} the output table will have
additional columns containing the total count of atoms of an element (e.g. \code{S_tot}).}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
The original table \code{mfd} as data.table having additional columns:
\describe{
\item{mf}{Standardized molecular formula following the Hill order.}
\item{mf_iso}{If \code{isotope_formulas = TRUE}:
Standardized molecular formula considering all isotopes of an element.}
\item{C_tot}{If \code{keep_element_sums = TRUE}:
The total count of all atoms that are carbon isotopes (similar for all other elements.}
}
}
\description{
Creates a character vector of molecular formulas and adds it as a column to the input \code{data.table}.
The molecular formula string follows the \strong{Hill system order} for element arrangement.
If keep_element_sums == TRUE, a data.table is returned that also provides
the sum of atoms of each element in the molecular formula.
}
\details{
This function extracts element or isotope counts from a table with columns for each element of a molecular formula,
including those with isotopic notation.
It ensures that only valid elements are included based on a reference table (\code{masses}).

The function internally uses the \code{ume::masses} table that contains element and isotopic symbols.
}
\section{Notes}{

\itemize{
\item The function correctly handles isotopic notations such as \verb{[13C]} and \verb{[18O2]}.
\item The output follows the \strong{Hill order}, meaning \strong{C, H first}, followed by other elements in alphabetical order.
\item Single-element counts (e.g., \code{C1H4} → \code{CH4}) are formatted without explicit \code{1}.
}
}

\examples{
convert_data_table_to_molecular_formulas(mf_data_demo[, .(`12C`, `1H`, `14N`, `16O`, `31P`, `32S`)])
}
\seealso{
Other molecular formula functions: 
\code{\link{convert_molecular_formula_to_data_table}()}
}
\concept{molecular formula functions}
\keyword{chemistry}
\keyword{molecular-formula}
