% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_metadata_from_UFZ_files.R
\name{extract_metadata_from_ufz_files}
\alias{extract_metadata_from_ufz_files}
\title{Extract Metadata from UFZ FTMS Filenames}
\usage{
extract_metadata_from_ufz_files(folder_path = NULL, file_type = NULL)
}
\arguments{
\item{folder_path}{(Optional) The path to the directory containing the XML files.}

\item{file_type}{(Default: ".xml")
If not provided, the user will be prompted to choose a file path interactively.}
}
\value{
A data.table containing extracted metadata fields from each filename. The columns are:
\itemize{
\item \code{sample_id}: Identifier for the sample.
\item \code{sample_id_ufz}: Identifier specific to UFZ's format, if available.
\item \code{position}: Position or condition identifier in the experiment.
\item \code{date}: Experiment date, formatted as \code{Date}.
\item \code{segment}: Segment information related to time or experiment phase.
\item \code{ret_time}: Retention time range within the segment.
\item \code{file_long}: Original filename after format adjustments.
\item \code{file}: Filename without the XML extension.
\item \code{link_rawdata}: Original filename as a link to raw data.
\item \code{ID}: Unique row identifier for each entry.
}
}
\description{
This function extracts metadata from XML filenames following the UFZ FTMS naming conventions.
It parses elements like sample ID, position, date, and retention time, organizing them into a structured data.table.
}
\details{
This function reads XML filenames from a specified folder and splits their components into structured metadata fields. It processes the filenames to ensure a consistent format by replacing an underscore preceding the 4-digit sample number with a hyphen. The function then extracts key information (e.g., sample ID, experiment date, retention time) based on the UFZ FTMS naming conventions and outputs a tidy data.table.

The expected filename format is as follows:
\itemize{
\item Standard: \code{104B12_9557_RB3_10-12-2023_Segment1_1-2min.xml}
\item Exception with additional underscore in the first part: \code{srfa_mcs_9554_GA2_10-12-2023_Segment1_1-2min.xml}
}
}
\seealso{
Other internal functions: 
\code{\link{create_custom_formula_library}()},
\code{\link{extract_aquisition_params}()},
\code{\link{extract_aquisition_params_from_folder}()},
\code{\link{read_xml_peaklist}()}
}
\concept{internal functions}
\keyword{internal}
\keyword{metadata}
