% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{known_mf}
\alias{known_mf}
\title{Collection of known formulas, for which additional information is available.}
\format{
A data.table with ~300,000 rows and 14 variables:
\describe{
\item{mz}{Mass to charge ratio (numeric)}
\item{mf}{molecular formula}
}
}
\source{
{taken from www.awi.de}
}
\usage{
known_mf
}
\description{
Known formulas; contains formulas for which additional knowledge is available.
This can be also calibration lists.
Due to size reasons the table is restricted to what is covered by standard UME formula library
(mz<=700, elements CHONSP considered).
The original version is part of the UME database and transferred to UME using UTF-8 encoding.
CRAM molecular formulas are taken from the supplementary material that is provided by Hertkorn et al. (2006).
}
\examples{
data(known_mf)
}
\seealso{
Other ume data: 
\code{\link{lib_demo}},
\code{\link{masses}},
\code{\link{mf_data_demo}},
\code{\link{nice_labels_dt}},
\code{\link{peaklist_demo}},
\code{\link{tab_ume_labels}}
}
\concept{ume data}
\keyword{datasets}
