% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_n_mf_per_sample.R
\name{uplot_n_mf_per_sample}
\alias{uplot_n_mf_per_sample}
\title{Number of Molecular Formulas per Sample Plot}
\usage{
uplot_n_mf_per_sample(
  df,
  col = "grey",
  logo = TRUE,
  width = 0.3,
  gg_size = 12,
  plotly = FALSE
)
}
\arguments{
\item{df}{A data.table containing at least a \code{file_id} column.}

\item{col}{Character. Fill color for the bars (default \code{"grey"}).}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{width}{Numeric. Width of bars (default \code{0.3}).}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}
}
\value{
A \code{ggplot} object, or a \code{plotly} object if \code{plotly = TRUE}.
}
\description{
Creates a bar plot showing how many molecular formulas were assigned per
sample (\code{file_id}). The plot title contains the mean and standard deviation
of assigned molecular formulas across samples. Optionally, the plot can be
converted to an interactive Plotly plot or display the UltraMassExplorer logo.
}
\details{
Number of Molecular Formulas per Sample / File
}
\examples{
uplot_n_mf_per_sample(mf_data_demo)

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
