% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{QCplot}
\alias{QCplot}
\title{Generate QC plots}
\usage{
QCplot(
  object,
  group.by = "sample",
  plotDepth = 3,
  assays = NULL,
  samples = NULL,
  theme = "classic",
  option = "viridis",
  direction = "default",
  toggle_mean = TRUE,
  center = "mean",
  line_col = "blue",
  angle = 0,
  plotly = FALSE
)
}
\arguments{
\item{object}{Requires a UMI sample or UMI experiment object}

\item{group.by}{String. Which variable should be used as a factor on the x-axis. Default is sample}

\item{plotDepth}{Which consensus depth to plot}

\item{assays}{(Optional) user-supplied list of assays to plot. Default is all.}

\item{samples}{(Optional) user-supplied list of samples to plot. Default is all.}

\item{theme}{ggplot theme to use.}

\item{option}{Color palette to use, either ggplot default or viridis colors.}

\item{direction}{If viridis colors are used, choose orientation of color scale.}

\item{toggle_mean}{Show mean or median}

\item{center}{Choose mean or median}

\item{line_col}{Choose color for mean/median line}

\item{angle}{Angle of labels on x-axis.}

\item{plotly}{Should plotly be used for rendering?}
}
\value{
A ggplot object
}
\description{
Visualize the UMI count for each selected assay and sample for a given
consensus depth. This is useful to detect differences in coverage,
especially for multiplexed assays.
}
\examples{
library(umiAnalyzer)

main = system.file('extdata', package = 'umiAnalyzer')
samples <- list.dirs(path = main, full.names = FALSE, recursive = FALSE)
simsen <- createUmiExperiment(experimentName = 'example',mainDir = main,sampleNames = samples)

depth_plot <- QCplot(simsen)

}
