% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{findConsensusReads}
\alias{findConsensusReads}
\title{Find consensus reads
A function to analyze consensus read tables generated with parseBamFiles or
a UMIexperiment object containing reads.}
\usage{
findConsensusReads(
  object,
  consDepth = 0,
  groupBy = c("none", "sample", "position", "both"),
  pattern = NULL
)
}
\arguments{
\item{object}{Either a tibble generated with parseBamFiles or a UMIexperiment object}

\item{consDepth}{Minimum consensus depth to keep. Default is 0.}

\item{groupBy}{Should data be grouped by position, sample, both or not at all.}

\item{pattern}{Regular expression}
}
\value{
A data table
}
\description{
Find consensus reads
A function to analyze consensus read tables generated with parseBamFiles or
a UMIexperiment object containing reads.
}
\examples{
\donttest{
library(umiAnalyzer)
main <- system.file("extdata", package = "umiAnalyzer")
simsen <- createUmiExperiment(main, importBam = TRUE)

reads <- findConsensusReads(simsen)
reads
}

}
