% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin_rules.R
\name{models_rubin_rules}
\alias{models_rubin_rules}
\title{Pool regression coefficients and standard errors via Rubin's rules}
\usage{
models_rubin_rules(list, df = NULL, cluster = NULL)
}
\arguments{
\item{list}{A list of fitted model objects (e.g., `lm`, `glm`, etc.)
for which `lmtest::coeftest()` methods exist.}

\item{df}{Optional. Degrees of freedom for t-distribution when computing p-values. If `NULL`, uses the degrees of freedom from the first model's `coeftest` output, i.e. the df from the original model.}

\item{cluster}{Optional. A clustering variable passed to `sandwich::vcovCL()`. Typically a one-sided formula specficying clusters, e.g., `~ cluster_id`}
}
\value{
A numeric matrix with the same layout as `lmtest::coeftest()`,
  containing pooled coefficients, pooled standard errors, t-statistics, and
  two-sided p-values. The returned object uses the first element's
  `coeftest` matrix as a template (including row/column names and attributes).
}
\description{
Pools coefficient estimates and standard errors from multiple fitted models
(typically one per dataset) using Rubin's rules, returning a
`coeftest`-like matrix with pooled estimates, SEs, t-statistics, and p-values. Can be used when when pooling mulitple models with different draws from the UCDP uncertainty model.
}
\details{
If `cluster` is provided, cluster-robust covariance matrices are computed for
each model via `sandwich::vcovCL()` and passed to `lmtest::coeftest()`.


The pooling follows the usual within/between decomposition:
within-imputation variance is the mean of squared SEs, and between-imputation
variance is the sample variance of point estimates across imputations. The
total variance is \eqn{W + (1 + 1/m)B} where \eqn{m} is the number of models.
}
\examples{
library(foreach)
library(dplyr)
# Draw 100 datasets from UCDP uncertainty model and return as a list
data('ucdpged')
ucdp_sb <- ucdpged \%>\% filter(type_of_violence == 1)
list_of_models <- foreach(i = 1:100) \%do\%{
 lm(ged_sb_draw ~ year + region, data =
ucdp_sb \%>\% mutate(ged_sb_draw = runcertainUCDP(n = n(), fatalities = best, tov = 'sb')))
}
#' # Pool model coefficients and standard errors via Rubin's rules
pooled_results <- models_rubin_rules(list_of_models)



}
