% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untangle_fn.R
\name{untangle2}
\alias{untangle2}
\title{Rectangling embedded subheaders}
\usage{
untangle2(df, regex, orig, new)
}
\arguments{
\item{df}{A data frame with embedded subheaders.}

\item{regex}{Regular expression to match the subheaders.}

\item{orig}{Variable containing the extraneous subheaders.}

\item{new}{Name of variable that will contain the group values.}
}
\value{
A tibble without the matched subheaders and a new variable containing
the grouping data.
}
\description{
Rectangling embedded subheaders
}
\details{
Special thanks to Jenny Bryan for fixing the initial tidyeval code
and overall function structure.
}
\examples{
data(primates2017)
# put taxonomic family in its own variable (matches the suffix "DAE")
untangle2(primates2017, "DAE$", scientific_name, family)
# put geographic regions in their own variable (matching them all by name)
untangle2(
  primates2017, "Asia|Madagascar|Mainland Africa|Neotropics",
  scientific_name, family
)
# with magrittr pipes (re-exported in this package)
primates2017 \%>\%
  untangle2("DAE$", scientific_name, family) \%>\%
  untangle2(
    "Asia|Madagascar|Mainland Africa|Neotropics",
    scientific_name, region
  )
}
