% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aalto.R
\docType{data}
\name{aalto_2}
\alias{aalto_2}
\title{Primary brand colours of Aalto University, Finland}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on 
\href{https://www.aalto.fi/fi}{AU}'s 
\href{https://brand.aalto.fi/visual-identity/about/colour-palette}{brand guide} (HTML).
}
\usage{
aalto_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{aalto_2} provides the departmental colours 
for the different schools 
of \href{https://www.aalto.fi/fi}{Aalto University}, Finland.
}
\details{
\code{aalto_2} is based on HEX color definitions.
}
\examples{
aalto_2
unikn::seecol(aalto_2, 
              main = "Departmental colours of Aalto University, Finland") # view palette

}
\seealso{
\code{\link{aalto_2}} for departmental colours of Aalto University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Finnish university color palettes: 
\code{\link{aalto_1}},
\code{\link{helsinki_1}},
\code{\link{helsinki_2}},
\code{\link{helsinki_3}}
}
\author{
\strong{unicol}, 2023-10-15.
}
\concept{Finnish university color palettes}
\keyword{datasets}
