% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McMaster.R
\docType{data}
\name{mcmaster_heritage}
\alias{mcmaster_heritage}
\title{Heritage colours of McMaster University, Canada}
\format{
An object of class \code{character} of length 3.
}
\source{
Colour definitions are based on \href{https://www.mcmaster.ca}{McMaster}'s 
\href{https://brand.mcmaster.ca/guidelines_introduction/web-guidelines/}{Digital brand manual} (PDF).
}
\usage{
mcmaster_heritage
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{mcmaster_heritage} provides the three heritage colours 
of \href{https://www.mcmaster.ca}{McMaster University}, Canada.
}
\details{
The heritage colours are
\code{"McMaster heritage maroon"} (defined as HEX #7A003C),
\code{"McMaster heritage gold"} (defined as HEX #FDBF57), and
\code{"McMaster heritage grey"} (defined as HEX #5E6A71).


The heritage colours are used in association with all 
\href{https://www.mcmaster.ca}{McMaster} materials.

Strengthen the McMaster brand by consistently using the McMaster colour palette 
across all digital communications. The rich hues suggest tradition and solidity. 
These colours are all reflected in the McMaster logo, an essential element of our brand identity. 
\code{McMaster heritage maroon} is a key brand colour. 
Continue to use this Heritage colour for all digital applications where appropriate. 
The Brighter World colours are to be used in all brand communications in addition to the Heritage colours.
}
\examples{
mcmaster_heritage
unikn::seecol(mcmaster_heritage, main = "McMaster Heritage Colours") # view colour palette

}
\seealso{
\code{\link{mcmaster_brighterworld}} for the brighter world colours of McMaster University; 
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{Canadian university color palettes}
\keyword{datasets}
