% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_2}
\alias{stanford_2}
\title{Accent colors of Stanford University, USA}
\format{
An object of class \code{character} of length 42.
}
\source{
Color definitions are based on \href{https://www.stanford.edu}{Stanford}'s 
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_2} provides the 42 accent colors
of \href{https://www.stanford.edu}{Stanford University}, CA, USA.
}
\details{
The following colors are intended to compliment the primary colors: 
\code{"Palo alto"} (defined as HEX #175E54),
\code{"Palo alto light"} (defined as HEX #2D716F),
\code{"Palo alto dark"} (defined as HEX #014240),
\code{"Palo verde"} (defined as HEX #279989),
\code{"Palo verde light"} (defined as HEX #59B3A9),
\code{"Palo verde dark"} (defined as HEX #017E7C),
\code{"olive"} (defined as HEX #8F993E),
\code{"olive light"} (defined as HEX #A6B168),
\code{"olive dark"} (defined as HEX #7A863B),
\code{"bay"} (defined as HEX #6FA287),
\code{"bay light"} (defined as HEX #8AB8A7),
\code{"bay dark"} (defined as HEX #417865),
\code{"sky"} (defined as HEX #4298B5),
\code{"sky light"} (defined as HEX #67AFD2),
\code{"sky dark"} (defined as HEX #016895),
\code{"Lagunita"} (defined as HEX #007C92),
\code{"Lagunita light"} (defined as HEX #009AB4),
\code{"Lagunita dark"} (defined as HEX #006B81),
\code{"poppy"} (defined as HEX #E98300),
\code{"poppy light"} (defined as HEX #F9A44A),
\code{"poppy dark"} (defined as HEX #D1660F),
\code{"spirited"} (defined as HEX #E04F39),
\code{"spirited light"} (defined as HEX #F4795B),
\code{"spirited dark"} (defined as HEX #C74632),
\code{"illuminating"} (defined as HEX #FEDD5C),
\code{"illuminating light"} (defined as HEX #FFE781),
\code{"illuminating dark"} (defined as HEX #FEC51D),
\code{"plum"} (defined as HEX #620059),
\code{"plum light"} (defined as HEX #734675),
\code{"plum dark"} (defined as HEX #350D36),
\code{"brick"} (defined as HEX #651C32),
\code{"brick light"} (defined as HEX #7F2D48),
\code{"brick dark"} (defined as HEX #42081B),
\code{"archway"} (defined as HEX #5D4B3C),
\code{"archway light"} (defined as HEX #766253),
\code{"archway dark"} (defined as HEX #2F2424),
\code{"stone"} (defined as HEX #7F7776),
\code{"stone light"} (defined as HEX #D4D1D1),
\code{"stone dark"} (defined as HEX #544948),
\code{"fog"} (defined as HEX #DAD7CB),
\code{"fog light"} (defined as HEX #F4F4F4), and
\code{"fog dark"} (defined as HEX #B6B1A9).


Although the primary palette (see \code{\link{stanford_1}}) should drive most 
\href{https://www.stanford.edu}{Stanford} communication materials, 
other colors can be added as appropriate. 
For those circumstances, we have developed this accent palette.
}
\examples{
stanford_2
unikn::seecol(stanford_2, main = "Accent colors of Stanford University")  # view palette

}
\seealso{
\code{\link{stanford_1}} for primary colors of Stanford University;
\code{\link{stanford_3}} for web colors of Stanford University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
