% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Koeln.R
\docType{data}
\name{uni_koeln_2}
\alias{uni_koeln_2}
\title{Departmental colors of the University of Koeln (Cologne), Germany}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://kommunikation-marketing.uni-koeln.de/marketing/corporate_design/index_ger.html}.
}
\usage{
uni_koeln_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_koeln_2} provides the departmental (faculty) colors 
of the \href{https://www.uni-koeln.de}{Universitaet zu Koeln}, Germany.
}
\details{
The named colors of \code{uni_koeln_2} correspond to the following departments:

\enumerate{
\item \code{gruen}: Wirtschafts-/Sozialwissenschaftliche Fakultaet
\item \code{bordeaux}: Rechtswissenschaftliche Fakultaet 
\item \code{rot}: Medizinische Fakultaet
\item \code{violett}: Philosophische Fakultaet
\item \code{blau}: Mathematisch-Naturwissenschaftliche Fakultaet
\item \code{orange}: Humanwissenschaftlicheschaftliche Fakultaet 
\item \code{hellblau}: Verwaltung 
}
}
\examples{
uni_koeln_2
unikn::seecol(uni_koeln_2, main = "Departmental colors of Uni Koeln")
unikn::demopal(uni_koeln_2, type = 3, 
               main = "Department colors at the University of Cologne")

}
\seealso{
\code{\link{uni_koeln_1}} for primary colors of the University of Koeln;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-05.
}
\concept{German university color palettes}
\keyword{datasets}
