% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlgeom.R
\name{mlgeom}
\alias{mlgeom}
\title{Geometric distribution maximum likelihood estimation}
\usage{
mlgeom(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{not in use.}
}
\value{
\code{mlgeom} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{prob} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
For the density function of the Geometric distribution see
\link[stats:Geometric]{Geometric}.
}
\examples{
mlgeom(corbet)
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.
}
\seealso{
\link[stats:Geometric]{Geometric} for the density.
}
