% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlstd.R
\name{mlstd}
\alias{mlstd}
\title{Student-t distribution maximum likelihood estimation}
\usage{
mlstd(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlstd} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
the parameters \code{mean}, \code{sd}, \code{nu} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Joint maximum likelihood estimation as implemented by \link[fGarch:dist-stdFit]{fGarch::stdFit}.
}
\details{
For the density function of the Student t-distribution see
\link[fGarch:dist-std]{std}.
}
\examples{
mlstd(precip)
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995)
Continuous Univariate Distributions, Volume 1, Chapter 13. Wiley, New York.
}
\seealso{
\link[fGarch:dist-std]{std} for the Student-t density.
}
