% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count_param_values}
\alias{count_param_values}
\title{Count different values for a specified parameter across query strings}
\usage{
count_param_values(query, param_name, sort = FALSE, name = "n")
}
\arguments{
\item{query}{A character vector of query strings.}

\item{param_name}{The name of the parameter whose values to count.}

\item{sort}{Logical indicating whether to sort the output by count. Defaults
to FALSE.}

\item{name}{The name of the column containing the counts. Defaults to 'n'.}
}
\value{
A tibble with each value of the specified parameter and how often it occurs.
}
\description{
Count different values for a specified parameter across query strings
}
\examples{
count_param_values(c("param1=value1&param2=value2", "param1=value3"), "param1")
}
