% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersection_powerset.R
\name{powerset_icounts}
\alias{powerset_icounts}
\title{Powerset Intersection Table}
\usage{
powerset_icounts(ids)
}
\arguments{
\item{ids}{\code{list()}\cr
A named list, each element being a numeric vector of ids.}
}
\value{
A tibble with columns:
\itemize{
\item \code{set_combo}: name for combo set/vector
\item \code{num_subsets}: number of subsets in the combo set
\item \code{common_ids}: vector of common ids in the combo set
\item \code{count}: number of common ids
}
}
\description{
This function computes the intersection of elements for all possible
combinations of the provided sets of IDs.
A typical use case is in a cohort of patients with incomplete data across
multiple data types. This function helps determine how many patients
have complete data for specific combinations of data types, allowing
you to find the optimal combinations for analysis.
}
\examples{
library(dplyr)
ids = list(a = 1:3, b = 2:5, c = 1:4, d = 3:6, e = 2:6)
res = powerset_icounts(ids)

res |>
  filter(num_subsets >= 2, count > 2) |>
  arrange(desc(count), desc(num_subsets))

}
