% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_access_utilities.R
\name{extract_modules_to_yaml}
\alias{extract_modules_to_yaml}
\title{Extract Non-Parent Module Labels to \code{YAML}}
\usage{
extract_modules_to_yaml(mods, filepath, verbose = FALSE)
}
\arguments{
\item{mods}{(\code{teal_module} or \code{teal_modules}) a teal modules object
containing the module structure.}

\item{filepath}{(\code{character(1)}) character string specifying the output \code{YAML} file path.}

\item{verbose}{(\code{logical(1)}) whether to print informational messages. Default is \code{FALSE}.}
}
\value{
Character vector of non-parent module labels
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Extracts module labels from a teal modules object, filters out parent modules
(grouping containers), and generates a \code{YAML} file with the functional modules.
}
\examples{
# Extract modules from mods object to YAML file
mods <- teal::modules(
  teal::example_module("mod1"),
  teal::example_module("mod2")
)
labels <- extract_modules_to_yaml(mods, "panel_str_modules.yml")
unlink("panel_str_modules.yml")

}
