% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funor_funom.R
\name{funor_funom}
\alias{funor_funom}
\title{Identifies and treats outliers in a two-way table}
\usage{
funor_funom(x, A_r = 10, B_r = 1.5, A_m = 0, B_m = 1.5)
}
\arguments{
\item{x}{Two-way table to treat for outliers}

\item{A_r}{A for the FUNOR phase (see FUNOP for details)}

\item{B_r}{B for the FUNOR phase
slope}

\item{A_m}{A for the FUNOM phase (\code{A_m} is usually 0)}

\item{B_m}{B for the FUNOM phase}
}
\value{
A two-way table of the same size as \code{x}, treated for outliers.
}
\description{
FUNOR-FUNOM stands for FUll NOrmal Rejection-FUll NOrmal Modification.

The procedure treats a two-way (contingency) table for outliers by
isolating residuals from the table's likely systemic effects, which
are calculated from the table's grand, row, and column means.

The residuals are passed to separate \emph{rejection} (FUNOR) and
\emph{modification} (FUNOM) procedures, which both depend upon FUNOP
to identify outliers. As such, this procedure requires two sets of
\code{A} and \code{B} parameters.

The procedure treats outliers by reducing their residuals, resulting
in values that are much closer to their expected values (i.e.,
combined grand, row, and column effects).
}
\examples{
funor_funom(table_2)
which(funor_funom(table_2) != table_2)
}
\references{
Tukey, John W. "The Future of Data Analysis."
\emph{The Annals of Mathematical Statistics},
\emph{33}(1), 1962, pp 1-67. \emph{JSTOR},
\url{https://www.jstor.org/stable/2237638}.
}
\seealso{
\code{\link[=funop]{funop()}}
}
