% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nu.R
\name{nu}
\alias{nu}
\title{nu}
\usage{
nu(o, p)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}
}
\value{
Non-unity slope (NU)
}
\description{
Calculates the Non-unity slope (NU) from observed
and predicted values.
}
\details{
Interpretation: closer to 1 is better.
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 2, 4, 5, 6, 8, 7, 10)
nu(o=obs, p=pred)

}
\references{
Piikki K., Wetterlind J., Soderstrom M., Stenberg B. (2021). Perspectives
on validation in digital soil mapping of continuous attributes. A review.
Soil Use and Management. \doi{10.1111/sum.12694}
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
