% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca_pvar.R
\name{fit_panel_var}
\alias{fit_panel_var}
\title{Fit Panel VAR Model}
\usage{
fit_panel_var(panel_data, max_lags = 2L, verbose = TRUE)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{max_lags}{Maximum lag order to consider. Default 2.}

\item{verbose}{Logical. Print progress. Default TRUE.}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted panelvar model}
  \item{best_lag}{Selected lag order}
  \item{bic_values}{BIC for each lag order tested}
}
}
\description{
Fits a panel vector autoregression model with first-difference transformation.
}
\examples{
\donttest{
if (requireNamespace("panelvar", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2019, 5),
    sector = rep(LETTERS[1:5], each = 20),
    log_direct = rnorm(100, 5, 0.5),
    log_production = rnorm(100, 5, 0.5)
  )

  result <- fit_panel_var(panel)
  print(result$best_lag)
}
}

}
