% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca_pvar.R
\name{run_cca_var_analysis}
\alias{run_cca_var_analysis}
\title{Run Complete CCA and VAR Analysis}
\usage{
run_cca_var_analysis(
  direct_prices,
  production_prices,
  panel_data,
  cca_components = 3L,
  verbose = TRUE
)
}
\arguments{
\item{direct_prices}{Data frame with direct prices.}

\item{production_prices}{Data frame with production prices.}

\item{panel_data}{Data frame in panel format.}

\item{cca_components}{Number of CCA components. Default 3.}

\item{verbose}{Logical. Print progress. Default TRUE.}
}
\value{
A list with cca, pvar, agg_var, and granger results.
}
\description{
Convenience function to run both sparse CCA and panel/aggregated VAR.
}
\examples{
\donttest{
set.seed(123)
years <- 2000:2019
sectors <- LETTERS[1:5]

direct <- data.frame(Year = years)
production <- data.frame(Year = years)
for (s in sectors) {
  direct[[s]] <- 100 + cumsum(rnorm(20, 2, 1))
  production[[s]] <- 102 + cumsum(rnorm(20, 2, 1))
}

panel <- prepare_panel_data(direct, production)

matrices <- prepare_log_matrices(direct, production)

result <- run_cca_var_analysis(
  direct, production, panel,
  cca_components = 2
)
}

}
