% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_importance_analysis.R
\name{vs_importance_analysis}
\alias{vs_importance_analysis}
\title{Importance Analysis}
\usage{
vs_importance_analysis(vsc, vcf_source, labels, n_trees)
}
\arguments{
\item{vsc}{A variantspark connection.}

\item{vcf_source}{An object with \code{VCFFeatureSource} class, usually the
output of the \code{vs_read_vcf()}.}

\item{labels}{An object with \code{CsvLabelSource}  class, usually the output
of the \code{vs_read_labels()}.}

\item{n_trees}{The number of trees using in the random forest.}
}
\value{
spark_jobj, shell_jobj
}
\description{
This function performs an Importance Analysis using random forest algorithm.
For more details, please look at
\href{https://variantspark.readthedocs.io/en/latest/overview.html#importance-analysis}{here}.
}
\examples{
\dontrun{
library(sparklyr)
sc <- spark_connect(master = "local")
vsc <- vs_connect(sc)

hipster_vcf <- vs_read_vcf(vsc, 
                           system.file("extdata/hipster.vcf.bz2",
                                       package =  "variantspark"))

labels <- vs_read_labels(vsc, 
                         system.file("extdata/hipster_labels.txt",
                                      package =  "variantspark"))

vs_importance_analysis(vsc, hipster_vcf, labels, 10)
}

}
