varoc=function(y,x,zlim=NULL,plot=TRUE,digits=2,pval="no",B=2000){

  fit=tmd_ft(y=y,x=x,pval=pval)


  if(plot==TRUE){
    legend="right"
    cex.main=1
    cex=1
    cex.axis=1
    cex.lab=1
    cex.legend=1
    lwd=1
    Alpha=0.9
    main="VAROC"
    ylab="TPF"
    xlab="FPF"
    clab="TMD"

    if(is.null(zlim)){
      tmd.min=tmd.max=NULL
    }else{
      tmd.min=zlim[1]
      tmd.max=zlim[2]
    }

    #1.data
    tmd=fit$res1$tmd
    tpf=fit$res1$tpf
    fpf=fit$res1$fpf
    M=length(tmd)

    auc=fit$res2$auc
    itmd=fit$res2$itmd

    tmd.title="TMD"
    itmd.title="ITMD="

    #2. tmd range
    tmd.min0=min(tmd,na.rm=TRUE)
    tmd.max0=max(tmd,na.rm=TRUE)

    if(is.null(tmd.min)){
      tmd.min=tmd.min0
    }else{
      tmd.min=min(tmd.min,tmd.min0)
    }
    if(is.null(tmd.max)){
      tmd.max=tmd.max0
    }else{
      tmd.max=max(tmd.max,tmd.max0)
    }
    tmd.range=c(tmd.min,tmd.max)

    #3.plot
    df=data.frame(x=fpf,y=tpf,z=tmd) #faster
    df=df[!duplicated(df),]
    x=df$x
    y=df$y
    z=df$z

    plot3D::scatter2D(x=x, y=y, colvar = z, pch = 19, ylab = ylab, xlab=xlab, clab=clab, cex = cex, clim=tmd.range, type='n', main=main, alpha=Alpha)
    lines(x=c(0,1),y=c(0,1),col="darkgray",lwd=lwd)

    m=length(x)
    for(i in m:2){
      plot3D::scatter2D(x=x[i:(i-1)],y=y[i:(i-1)],colvar=z[i:(i+1)],pch=19,ylab=ylab, xlab=xlab,clab=clab,cex=cex,clim=tmd.range,type='s',add=TRUE,lwd=lwd,colkey=FALSE, alpha=Alpha)
      plot3D::scatter2D(x=x[i],y=y[i],colvar=z[i],pch=19,ylab=ylab, xlab=xlab,clab=clab,cex=cex,clim=tmd.range,add=TRUE,lwd=lwd,colkey=FALSE,alpha=Alpha)
    }

    if(legend%in%c("bottomleft", "topleft", "topright", "bottomright", "left", "right", "top", "bottom", "center")){
      AUC.text=paste0("AUC=",format(round(auc,digits),nsmall=digits))
      ITMD.text=paste0(itmd.title,format(round(itmd,digits),nsmall=digits))

      graphics::legend(legend,paste0(AUC.text,"\n",ITMD.text),adj=0,cex=cex.legend,bty='n')
    }
  }

  return(fit)
}
