% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.cor}
\alias{meta.ave.cor}
\title{Confidence interval for an average Pearson or partial correlation}
\usage{
meta.ave.cor(alpha, n, cor, s, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of estimated correlations}

\item{s}{number of control variables (set to 0 for Pearson)}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average Pearson or partial correlation from two or more studies. The
sample correlations must be all Pearson correlations or all partial
correlations. Use the meta.ave.cor.gen function to meta-analyze any
combination of Pearson, partial, or Spearman correlations.
}
\examples{
n <- c(55, 190, 65, 35)
cor <- c(.40, .65, .60, .45)
meta.ave.cor(.05, n, cor, 0, bystudy = TRUE)

# Should return:
#         Estimate         SE        LL        UL
# Average    0.525 0.05113361 0.4176678 0.6178816
# Study 1    0.400 0.11430952 0.1506943 0.6014699
# Study 2    0.650 0.04200694 0.5594086 0.7252465
# Study 3    0.600 0.08000000 0.4171458 0.7361686
# Study 4    0.450 0.13677012 0.1373507 0.6811071


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
