% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.r
\encoding{UTF-8}
\name{mark_area}
\alias{mark_area}
\title{Area mark}
\usage{
mark_area(vl, orient = NULL, stack = NULL, interpolate = NULL,
  tension = NULL, opacity = NULL, filled = NULL, color = NULL,
  fill = NULL, stroke = NULL)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{orient}{the orientation of a non-stacked bar, area, and line charts.
The value is either "horizontal", or "vertical" (default). For bar and
tick, this determines whether the size of the bar and tick should be
applied to x or y dimension. For area, this property determines the
orient property of the Vega output. For line, this property determines
the path order of the points in the line if path channel is not specified.
For stacked charts, this is always determined by the orientation of the stack;
therefore explicitly specified value will be ignored.}

\item{stack}{stacking modes for bar and area marks. \code{zero} - stacking
with baseline offset at zero value of the scale (for creating typical stacked
bar and area chart). \code{normalize} - stacking with normalized domain (for
creating normalized stacked bar and area chart). \code{center} - stacking
with center baseline (for streamgraph). \code{none} - No-stacking. This will
produces layered bar and area chart.}

\item{interpolate}{The line interpolation method to use. One of \code{linear}
\code{step-before}, \code{step-after}, \code{basis}, \code{basis-open},
\code{basis-closed}, \code{bundle}, \code{cardinal}, \code{cardinal-open},
\code{cardinal-closed}, \code{monotone}. For more information about each
interpolation method, please see D3’s line interpolation.}

\item{tension}{Depending on the interpolation type, sets the tension parameter.
(See D3’s line interpolation.)}

\item{opacity}{\code{0.0}-\code{1.0}}

\item{filled}{whether the shape's color should be used as fill color instead of stroke color.}

\item{color}{color of the mark – either fill or stroke color based on the filled mark config.}

\item{fill}{fill color. This config will be overridden by color channel’s
specified or mapped values if filled is true.}

\item{stroke}{stroke color. This config will be overridden by color channel’s
specified or mapped values if filled is false.}
}
\description{
An area represent multiple data element as a single area shape.
}
\examples{
vegalite() \%>\%
  cell_size(300, 200) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/unemployment-across-industries.json") \%>\%
  encode_x("date", "temporal") \%>\%
  encode_y("count", "quantitative", aggregate="sum") \%>\%
  encode_color("series", "nominal") \%>\%
  scale_color_nominal(range="category20b") \%>\%
  timeunit_x("yearmonth") \%>\%
  scale_x_time(nice="month") \%>\%
  axis_x(axisWidth=0, format="\%Y", labelAngle=0) \%>\%
  mark_area()
}
\references{
\href{http://vega.github.io/vega-lite/docs/mark.html}{Vega-Lite Mark spec}
}

