% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_to_text.R
\name{num_to_text}
\alias{num_to_text}
\title{Spell out numbers if they are smaller than ten}
\usage{
num_to_text(
  number,
  sentence_start = FALSE,
  zero_or_no = "no",
  uk_or_us = "UK",
  big_mark = ","
)
}
\arguments{
\item{number}{Whole number as \code{numeric} or \code{integer}, to be turned into text. Numbers 1-10 are always written out in full,
regardless of their place in the sentence. Number 11-999 are written out in full if they are at the beginning of a sentence.
Numbers greater than 1000 are returned as numerals.}

\item{sentence_start}{Logical. If \code{TRUE}, numbers below 100 are written out in full, and their first letter is capitalised.}

\item{zero_or_no}{Specify what to print when the number is 0. Defaults to "no". Can be any string.}

\item{uk_or_us}{Defaults to UK which adds an "and" between "hundred" and other numbers (e.g. "One hundred and five"). If "US"
is chosen, the "and" is removed (e.g. "One hundred five").}

\item{big_mark}{Defaults to "," (e.g. "1,999").}
}
\value{
A string
}
\description{
Spell out numbers if they are smaller than ten
}
\examples{
num_to_text(3)
num_to_text(333, sentence_start = TRUE)

}
