% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields_plot.R
\name{plotComponentMatrix}
\alias{plotComponentMatrix}
\title{General plotting function for multiple 24-2 or 30-2 visual field measurements together:}
\usage{
plotComponentMatrix(componentmatrix, ncomp = ncol(componentmatrix),
  plot.ncols = 5, plot.nrows = NULL,
  plot.annot.topleft.function = toString,
  plot.annot.bottomleft.function = function(i) NULL,
  globaltitle = sprintf("k = \%i", ncol(componentmatrix)),
  globalannotright = NULL,
  zmin = -ceiling(max(abs(c(min(componentmatrix),
  max(componentmatrix))))), zmax = -zmin,
  color.pal = colorRampPalette(c("red", "white", "blue"), space =
  "Lab")(256), td.probabilities = FALSE,
  show.colorbar = !td.probabilities, titleheight = 0.2, ...)
}
\arguments{
\item{componentmatrix}{a matrix or data frame, column represents different eyes and rows are the VF measurements of the same type (sensitivity, TD, TD prob, PD, or PD prob).}

\item{ncomp}{a numeric variable defines the number of components to be plotted (default: all).}

\item{plot.ncols}{a numeric variable defines the number of columns to be plotted (default: 5).}

\item{plot.nrows}{a numeric variable defines the number of rows to be plotted (default: NULL (automatically calculated)).}

\item{plot.annot.topleft.function}{a function(i) that is given to any subplot i to create its top left annotation.}

\item{plot.annot.bottomleft.function}{a function(i) that is given to any subplot i to create its bottom left annotation (default: returns NULL).}

\item{globaltitle}{a string for global title (default: k = ncomp; set to NULL to suppress global title).}

\item{globalannotright}{a string annotation to the right of the global title (default: NULL).}

\item{zmin}{minimum value of the color scale (default: auto defined).}

\item{zmax}{maximum value of the color scale (default: auto defined).}

\item{color.pal}{an object that defines color scale theme (default: colorRampPalette(c("red", "white", "blue"), space = "Lab")(256)).}

\item{td.probabilities}{a logic variable indicates whether to plot TD probability symbols instead of TD colors (default: FALSE).}

\item{show.colorbar}{a logic variable indicates whether to show a global colorbar (default: !td.probabilities).}

\item{titleheight}{a numeric variable defines the height of the title relative to height of row one.}

\item{...}{other variables to be added.}
}
\value{
heatmap for sensitivity, TD and PD input. Value plot for TD prob and PD prob input.
}
\description{
\code{plotComponentMatrix} plots the following 24-2 or 30-2 visual field measurement: sensitivity, TD, TD prob, PD, and PD prob:
}
\examples{
data(vfseries)
componentmatrix = t(vfseries[1:10, grepl('^s[0-9]+', colnames(vfseries))])
globaltitle = paste("Sensitivities, k = ", ncol(componentmatrix), sep = '')
plotComponentMatrix(componentmatrix, globaltitle = globaltitle)
componentmatrix = t(vfseries[1:10, grepl('^td[0-9]+', colnames(vfseries))])
globaltitle = paste("TDs, k = ", ncol(componentmatrix), sep = '')
plotComponentMatrix(componentmatrix, globaltitle = globaltitle)
componentmatrix = t(vfseries[1:10, grepl('^pd[0-9]+', colnames(vfseries))])
globaltitle = paste("PDs, k = ", ncol(componentmatrix), sep = '')
plotComponentMatrix(componentmatrix, globaltitle = globaltitle)
componentmatrix = t(vfseries[1:10, grepl('^tdp[0-9]+', colnames(vfseries))])
globaltitle = paste("TD Probs, k = ", ncol(componentmatrix), sep = '')
plotComponentMatrix(componentmatrix, globaltitle = globaltitle, td.probabilities = TRUE)
componentmatrix = t(vfseries[1:10, grepl('^pdp[0-9]+', colnames(vfseries))])
globaltitle = paste("PD Probs, k = ", ncol(componentmatrix), sep = '')
plotComponentMatrix(componentmatrix, globaltitle = globaltitle, td.probabilities = TRUE)
}
