% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields_plot.R
\name{plotTDvalues}
\alias{plotTDvalues}
\title{Value plotting function for 24-2 or 30-2 visual field measurement:}
\usage{
plotTDvalues(tds, cex.tds = 1, textcolor = function(x) "black",
  show.lines = T, ...)
}
\arguments{
\item{tds}{a vector contains sensitivity/TD/PD measurement. For 24-2 VF \code{tds} should have 52 or 54 elements. For 30-2 VF, \code{tds} should have 74 or 76 elements.}

\item{cex.tds}{a numeric variable for label size (default: 1).}

\item{textcolor}{a function defines the label color.}

\item{show.lines}{a logical variable indicates whether to show the horizontal and vertical lines.}

\item{...}{other variables to be added.}
}
\value{
value plot for sensitivity, TD and PD input.
}
\description{
\code{plotTDvalues} plots the following 24-2 or 30-2 visual field measurement: sensitivity, TD, and PD:
}
\examples{
data(vfseries)
tds = t(vfseries[1, grepl('^s[0-9]+', colnames(vfseries))])
plotTDvalues(tds)
title(main = "Sensitivity", line = 3)
tds = t(vfseries[1, grepl('^td[0-9]+', colnames(vfseries))])
plotTDvalues(tds)
title(main = "Total Dviation", line = 3)
tds = t(vfseries[1, grepl('^pd[0-9]+', colnames(vfseries))])
plotTDvalues(tds)
title(main = "Pattern Dviation", line = 3)
}
