% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENc.values.R
\name{ENc.values}
\alias{ENc.values}
\title{Effective Number of Codons (ENc).}
\usage{
ENc.values(df.fasta,genetic.code = "1",threshold=0)
}
\arguments{
\item{df.fasta}{a data frame with seq_name and its DNA sequence.}

\item{genetic.code}{a single string that uniquely identifies a genetic code to use.}

\item{threshold}{optional numeric, specifying sequence length, in codons, used for filtering.}
}
\value{
A data.frame containing the computed ENc values for each DNA sequences within df.fasta.
}
\description{
Measure the Effective Number of Codons (ENc) of DNA sequence. Using its modified version (Novembre, 2002).
}
\details{
For more information about ENc \href{https://academic.oup.com/mbe/article/19/8/1390/997706}{Novembre, 2002}.
}
\examples{
\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
}
\dontshow{fasta.v <- fasta.v[1:30,]}
# Calculate ENc
enc.df.v <- ENc.values(fasta.v)
\donttest{
enc.df.h <- ENc.values(fasta.h)
}

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
