% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agent_manager.R
\docType{class}
\name{agent_manager}
\alias{agent_manager}
\title{agent Manager}
\description{
A class that abstracts the management of aggregations of agent classes. Each village should have
an instance of a agent_manager to interface the agents inside.
}
\section{Methods}{

\describe{
\item{\code{add_agent()}}{Adds a single agent to the manager.}
\item{\code{get_average_age()}}{Returns the average age, in years, of all the agents.}
\item{\code{get_living_agents()}}{Gets a list of all the agents that are currently alive.}
\item{\code{get_states()}}{Returns a data.frame consisting of all of the managed agents.}
\item{\code{get_agent()}}{Retrieves a particular agent from the manager.}
\item{\code{get_agent_index()}}{Retrieves the index of a agent.}
\item{\code{initialize()}}{Creates a new manager instance.}
\item{\code{load()}}{Loads a csv file defining a population of agents and places them in the manager.}
\item{\code{remove_agent()}}{Removes a agent from the manager}
}
Creates a new agent manager instance.
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{agents}}{A list of agents objects that the agent manager manages.}

\item{\code{agent_class}}{A class describing agents. This is usually the default villager supplied 'agent' class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-agent_manager-new}{\code{agent_manager$new()}}
\item \href{#method-agent_manager-get_agent}{\code{agent_manager$get_agent()}}
\item \href{#method-agent_manager-get_living_agents}{\code{agent_manager$get_living_agents()}}
\item \href{#method-agent_manager-add_agent}{\code{agent_manager$add_agent()}}
\item \href{#method-agent_manager-remove_agent}{\code{agent_manager$remove_agent()}}
\item \href{#method-agent_manager-get_states}{\code{agent_manager$get_states()}}
\item \href{#method-agent_manager-get_agent_index}{\code{agent_manager$get_agent_index()}}
\item \href{#method-agent_manager-connect_agents}{\code{agent_manager$connect_agents()}}
\item \href{#method-agent_manager-get_living_population}{\code{agent_manager$get_living_population()}}
\item \href{#method-agent_manager-get_average_age}{\code{agent_manager$get_average_age()}}
\item \href{#method-agent_manager-add_children}{\code{agent_manager$add_children()}}
\item \href{#method-agent_manager-load}{\code{agent_manager$load()}}
\item \href{#method-agent_manager-clone}{\code{agent_manager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-new"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$new(agent_class = villager::agent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_class}}{The class that's being used to represent agents being managed
Given the identifier of a agent, sort through all of the managed agents and return it
if it exists.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_agent"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_agent}{}}}
\subsection{Method \code{get_agent()}}{
Return the R6 instance of a agent with identifier 'agent_identifier'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_agent(agent_identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_identifier}}{The identifier of the requested agent.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An R6 agent object
Returns a list of all the agents that are currently alive.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_living_agents"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_living_agents}{}}}
\subsection{Method \code{get_living_agents()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_living_agents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of living agents
Adds a agent to the manager.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-add_agent"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-add_agent}{}}}
\subsection{Method \code{add_agent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$add_agent(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{One or more agents}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Removes a agent from the manager
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-remove_agent"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-remove_agent}{}}}
\subsection{Method \code{remove_agent()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$remove_agent(agent_identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_identifier}}{The identifier of the agent being removed}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
Returns a data.frame of agents
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_states"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_states}{}}}
\subsection{Method \code{get_states()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_states()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Each row of the data.frame represents a agent object
}

\subsection{Returns}{
A single data.frame of all agents
Returns the index of a agent in the internal agent list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_agent_index"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_agent_index}{}}}
\subsection{Method \code{get_agent_index()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_agent_index(agent_identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_identifier}}{The identifier of the agent being located}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The index in the list, or R's default return value
Connects two agents together as mates
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-connect_agents"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-connect_agents}{}}}
\subsection{Method \code{connect_agents()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$connect_agents(agent_a, agent_b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{agent_a}}{A agent that will be connected to agent_b}

\item{\code{agent_b}}{A agent that will be connected to agent_a
Returns the total number of agents that are alive}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_living_population"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_living_population}{}}}
\subsection{Method \code{get_living_population()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_living_population()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of living agents
Returns the average age, in years, of all of the agents
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-get_average_age"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-get_average_age}{}}}
\subsection{Method \code{get_average_age()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$get_average_age()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This is an \emph{example} of the kind of logic that the manager might handle. In this case,
the manager is performing calculations about its aggregation (agents). Note that the 364 days needs to
work better
}

\subsection{Returns}{
The average age in years
Takes all of the agents in the manager and reconstructs the children
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-add_children"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-add_children}{}}}
\subsection{Method \code{add_children()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$add_children()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This is typically called when loading agents from disk for the first time.
When children are created during the simulation, the family connections are made
through the agent class and added to the manager via add_agent.
}

\subsection{Returns}{
None
Loads agents from disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-load"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-load}{}}}
\subsection{Method \code{load()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$load(file_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_name}}{The location of the file holding the agents.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Populates the agent manager with a set of agents defined in a csv file.
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-agent_manager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-agent_manager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{agent_manager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
