% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_clust.R
\name{info_clust}
\alias{info_clust}
\title{Description of a set of partitions}
\usage{
info_clust(out, which.lambda, X)
}
\arguments{
\item{out}{an object of class \code{spwkm}.}

\item{which.lambda}{an integer or a vector of integers
selecting the clusterings for which summaries are computed.}

\item{X}{a matrix or a data frame. The initial data set.}
}
\value{
\item{mean.by.clust}{a list of numerical matrices. Each matrix contains the mean values
of the numerical variables computed per cluster, for a given value of the regularization parameter.}

\item{freq.by.clust}{a list of numerical matrices. Each matrix contains the relative 
frequencies of each level associated to categorical variables, 
computed per cluster and for a given value of the regularization parameter.}

\item{lambda}{a scalar or a numerical vector. The selected values of the regularization
parameter. }
}
\description{
This function computes descriptive statistics of the clustering produced with 
group-sparse weighted k-means on numerical data, or with sparse weighted k-means on mixed data.
It displays the average of the numerical variables per cluster, and the relative frequencies 
of the levels in the categorical variables per cluster.
}
\details{
The values in \code{which.lambda} must be integers between 1 and \code{length(out$lambda)}. One may
thus select the clusterings corresponding to specific regularization parameters, or the whole set
of clusterings
obtained for the whole grid of \code{out$lambda}.
}
\examples{
data(HDdata)
out <- sparsewkm(X = HDdata[,-14], centers = 2)
info_clust(out, which.lambda=c(1,10,20), X = HDdata[,-14])
}
\seealso{
\code{\link{groupsparsewkm}}, \code{\link{sparsewkm}}
}
