% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSuitabilityToProba.R
\name{plotSuitabilityToProba}
\alias{plotSuitabilityToProba}
\title{Visualise the function that was used to transform environmental suitability into
probability of occurrence}
\usage{
plotSuitabilityToProba(sp, add = FALSE, ...)
}
\arguments{
\item{sp}{the output from \code{\link{convertToPA}}.}

\item{add}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, the relationship
will be added to the currently active graph.}

\item{...}{further arguments to be passed to \code{plot}. See 
\code{\link[graphics]{plot}} and \code{\link[graphics]{par}}.}
}
\description{
This function plots the relationships between the environmental suitability
and the probability of occurrence, which is used to generate the presence-
absence distribution. 
It requires the output from \code{\link{convertToPA}}.
}
\examples{
# Create an example stack with two environmental variables
a <- matrix(rep(dnorm(1:100, 50, sd = 25)), 
            nrow = 100, ncol = 100, byrow = TRUE)
env <- c(rast(a * dnorm(1:100, 50, sd = 25)),
         rast(a * 1:100))
names(env) <- c("variable1", "variable2")

parameters <- formatFunctions(variable1 = c(fun = 'dnorm', mean = 1e-04, 
                                             sd = 1e-04),
                              variable2 = c(fun = 'linearFun', a = 1, b = 0))
# Generation of the virtual species
sp1 <- generateSpFromFun(env, parameters)
sp1


# Converting to presence-absence, probablistic method, logistic conversion
# A species with a low prevalence:

sp1.lowprev <- convertToPA(sp1, species.prevalence = 0.1)
plotSuitabilityToProba(sp1.lowprev)

# A species with a high prevalence:

sp1.highprev <- convertToPA(sp1, species.prevalence = 0.9)
plotSuitabilityToProba(sp1.lowprev)

# Converting to presence-absence, probablistic method, linear conversion
# A species with a low prevalence:

sp1.lowprev <- convertToPA(sp1, species.prevalence = 0.1,
                           prob.method = "linear")
plotSuitabilityToProba(sp1.highprev)

# A species with a high prevalence:

sp1.highprev <- convertToPA(sp1, species.prevalence = 0.9,
                           prob.method = "linear")
plotSuitabilityToProba(sp1.highprev)

}
\author{
Boris Leroy \email{leroy.boris@gmail.com}
}
