% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/security.R
\name{sanitize_ip}
\alias{sanitize_ip}
\title{Sanitize IP address input}
\usage{
sanitize_ip(ip)
}
\arguments{
\item{ip}{Character string representing an IP address}
}
\value{
Sanitized IP address or throws error if invalid
}
\description{
Validates IP addresses (IPv4 and IPv6) and checks for private ranges
that shouldn't be submitted to VirusTotal.
}
\seealso{
Other security: 
\code{\link{is_api_key_configured}()},
\code{\link{sanitize_domain}()},
\code{\link{sanitize_file_path}()},
\code{\link{sanitize_hash}()},
\code{\link{sanitize_url}()},
\code{\link{security-utilities}}
}
\concept{security}
\keyword{internal}
