% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-compare.R
\name{vis_compare}
\alias{vis_compare}
\title{Visually compare two dataframes and see where they are different.}
\usage{
vis_compare(df1, df2)
}
\arguments{
\item{df1}{The first dataframe to compare}

\item{df2}{The second dataframe to compare to the first.}
}
\value{
\code{ggplot2} object displaying which values in each data frame are
present in each other, and which are not.
}
\description{
\code{vis_compare}, like the other \verb{vis_*} families, gives an at-a-glance ggplot
of a dataset, but in this case, hones in on visualising \strong{two} different
dataframes of the same dimension, so it takes two dataframes as arguments.
}
\examples{

# make a new dataset of iris that contains some NA values
aq_diff <- airquality
aq_diff[1:10, 1:2] <- NA
vis_compare(airquality, aq_diff)
}
\seealso{
\code{\link[=vis_miss]{vis_miss()}} \code{\link[=vis_dat]{vis_dat()}} \code{\link[=vis_guess]{vis_guess()}} \code{\link[=vis_expect]{vis_expect()}} \code{\link[=vis_cor]{vis_cor()}}
}
