% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-cor.R
\name{vis_cor}
\alias{vis_cor}
\title{Visualise correlations amongst variables in your data as a heatmap}
\usage{
vis_cor(
  data,
  cor_method = "pearson",
  na_action = "pairwise.complete.obs",
  facet,
  ...
)
}
\arguments{
\item{data}{data.frame}

\item{cor_method}{correlation method to use, from \code{cor}: "a character
string indicating which correlation coefficient (or covariance) is to be
computed. One of "pearson" (default), "kendall", or "spearman": can be
abbreviated."}

\item{na_action}{The method for computing covariances when there are missing
values present. This can be "everything", "all.obs", "complete.obs",
"na.or.complete", or "pairwise.complete.obs" (default). This option is
taken from the \code{cor} function argument \code{use}.,}

\item{facet}{bare unqouted variable to use for facetting}

\item{...}{extra arguments you may want to pass to \code{cor}}
}
\value{
ggplot2 object
}
\description{
Visualise correlations amongst variables in your data as a heatmap
}
\examples{
vis_cor(airquality)
vis_cor(airquality, facet = Month)
vis_cor(mtcars)
\dontrun{
# this will error
vis_cor(iris)
}
}
