% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dmat_projection}
\alias{dmat_projection}
\title{Plot a 2D MDS projection of a distance matrix}
\usage{
dmat_projection(dmat, point_colors = NULL, point_palette = NULL)
}
\arguments{
\item{dmat}{distance matrix}

\item{point_colors}{optional list of labels to color points (will be coerced to factor)}

\item{point_palette}{optional palette used with \code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}}}
}
\value{
a ggplot object
}
\description{
Plot a 2D MDS projection of a distance matrix
}
\examples{
dmat <- dist(iris[, c("Sepal.Width", "Sepal.Length")])
dmat_projection(dmat)
}
