% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xicor.R
\name{xicor}
\alias{xicor}
\title{Calculate Chatterjee's Rank Correlation Coefficient}
\usage{
xicor(x, y, ties = FALSE)
}
\arguments{
\item{x}{A numeric vector representing the independent variable.}

\item{y}{A numeric vector representing the dependent variable.}

\item{ties}{A logical value indicating whether to handle ties in the data.
Default is FALSE.

If \code{ties = TRUE}, the function adjusts for tied ranks (repeated values in the
data). This is important when there are many tied values in either \code{x} or
\code{y}, as it ensures accurate calculation by considering the maximum rank for
tied observations.

If \code{ties = FALSE}, the function assumes that there are no ties, or that ties
can be handled without additional computational effort. This option can offer
better performance when ties are rare or absent.}
}
\value{
A numeric value representing Chatterjee's rank correlation coefficient.
}
\description{
This function calculates Chatterjee's rank correlation coefficient, which
measures the association between two variables. It is particularly useful for
identifying monotonic relationships between variables, even if they are not
linear.
}
\details{
Unlike Pearson's correlation (which measures linear relationships),
Chatterjee's coefficient can handle non-linear monotonic relationships. It is
robust to outliers and can handle tied ranks, making it versatile for
datasets with ordinal data or tied ranks. This makes it a valuable
alternative to Spearman's and Kendall's correlations, especially when the
data may not meet the assumptions required by these methods.

By default, \code{ties = FALSE} is set to prioritize computational efficiency, as
handling ties requires additional processing. In cases where ties are present
or likely (such as when working with ordinal or categorical data), it is
recommended to set \code{ties = TRUE}.
}
\examples{
xicor(x = pq_data$Collaboration_hours, y = pq_data$Internal_network_size, ties = TRUE)
xicor(x = pq_data$Collaboration_hours, y = pq_data$Internal_network_size, ties = FALSE)


}
