% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/friends.R
\name{getFriends}
\alias{getFriends}
\title{Returns a list of user IDs or detailed information about a user's friends}
\usage{
getFriends(
  user_id = "",
  order = "",
  list_id = "",
  count = "",
  offset = "",
  fields = "",
  name_case = "",
  flatten = FALSE,
  v = getAPIVersion()
)
}
\arguments{
\item{user_id}{User ID. By default, the current user ID}

\item{order}{Sort order (name - by name, hints - by rating)}

\item{list_id}{ID of the friend list returned by the friends.getLists method to be used as the source. This parameter is taken into account only when the uid parameter is set to the current user ID}

\item{count}{Number of friends to return}

\item{offset}{Offset needed to return a specific subset of friends}

\item{fields}{Profile fields to return}

\item{name_case}{Case for declension of user name and surname}

\item{flatten}{Automatically flatten nested data frames into a single non-nested data frame}

\item{v}{Version of API}
}
\description{
Returns a list of user IDs or detailed information about a user's friends
}
\examples{
\dontrun{
friends_list <- getFriends(user_id=1, order='name', fields='bdate')
friends <- friends_list$items
}
}
