#' voiceR test Audio List
#'
#'
#' An audio list containing recordings for ten English-speaking participants.
#' Interested users can download an extended version of this data set
#' <a href="https://osf.io/zt5h2/?view_only=348d1d172435449391e8d64547716477">here</a>
#' Participants were seated with an experimenter in a sound-isolated room.
#' All voice recordings were collected using a Blue Yeti Microphone. We used
#' Audacity version 2.4.2 to record the audio files and saved all files using
#' a 32-bit WAV format.
#' Participants were instructed to read the phrase "I go to the bar" in either a happy
#' or a sad voice. The experimenter requested
#' each emotion one at a time and in random sequence to counter order effects.
#'
#' @name testAudioList
#' @docType data
#' @format `testAudioList`
#' A list containing 20 Wave objects. Each Wave object has as name its file name.
#' This file name contains three components separated by an underscore:
#' \describe{
#'   \item{First component}{combination of numbers and letters refers to the
#'   participant identifier, i.e., the ID component}
#'   \item{Second component}{refers to the intention or emotional aspect that
#'   the speaker is conveying: Happy, or Sad. This component makes
#'   reference to the main point that we want to compare in our data; in the
#'   voiceR package the main comparison component is called Condition, because
#'   it usually refers to experimental conditions.}
#'   \item{Third component}{provides additional information in the voiceR
#'   package. }
#' }
#' @examples
#' data(testAudioList)
NULL
