% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_volume.R
\name{volnmf_logdet}
\alias{volnmf_logdet}
\title{Update volume-regularized matrix \code{R} using logdet volume approximation.}
\usage{
volnmf_logdet(
  C,
  X,
  R,
  R.constraint = "pos",
  majorate = FALSE,
  extrapolate = TRUE,
  qmax = 100,
  w.vol = 0.1,
  delta = 1,
  err.cut = 0.001,
  n.iter = 1000
)
}
\arguments{
\item{C}{Numeric Matrices. Matrices involved in objective function.Matrix R serves as initialization.}

\item{X}{Numeric Matrices. Matrices involved in objective function.Matrix R serves as initialization.}

\item{R}{Numeric Matrices. Matrices involved in objective function.Matrix R serves as initialization.}

\item{R.constraint}{A character. Set up ('pos') or not ('no') non-negative constraints on matrix \code{R} (by default 'pos').}

\item{majorate}{A boolean. Majorate logdet each iteration (by default FALSE).}

\item{extrapolate}{A boolean. Use Nesterov acceleration (by default FALSE, currently is not supported).}

\item{qmax}{A numeric. Maximum asymptotic (1 - 1/qmax) of extrapolation step.}

\item{w.vol}{A numeric. Volume (logdet) weight in objective function.}

\item{delta}{A numeric. Determinant pseudocount in objective function.}

\item{err.cut}{A numeric. Stop algorithm if relative erro in R between iteration is less than \code{err.cut}.}

\item{n.iter}{An integer. Number of iterations.}
}
\value{
An updated matrix \code{R}.
}
\description{
\code{volnmf_logdet} finds matrix \code{R} that minimizes objective
\code{||X-C*R||^2 + w.vol*log(det(R)+delta)}.
}
