% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pee_missing_data.R
\name{generate_pee_missing_data}
\alias{generate_pee_missing_data}
\title{Generate example data for PEE}
\usage{
generate_pee_missing_data(
  outcome = "binary",
  p = 20,
  n = 200,
  pt1 = 0.5,
  tbeta = c(3/4, (-3)/4, 3/4, (-3)/4, 3/4, (-3)/4, (-3)/4, 3/4),
  miss_sig = c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
)
}
\arguments{
\item{outcome}{The type of response variable Y, choose "binary" for binary response or "count" for poisson response,defualt "binary"}

\item{p}{The dimension of the independent variable X,default 20.}

\item{n}{The Number of rows of generated data,default 200.}

\item{pt1}{Missing rate of independent variable X,default 0.5.}

\item{tbeta}{True value of the coefficient,default c(3/4,(-3)/4,3/4,(-3)/4,3/4,(-3)/4,(-3)/4,3/4).}

\item{miss_sig}{A 0-1 vector of length p, where 1 means that variable at the index is with missing,while 0 means that it without missing,defualt c(1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}
}
\value{
A Matrix,missing data with variables X in the first p columns and response Y at the last column.
}
\description{
This is a functoin to generate example missing data for PEE
}
